<?php

/**
 * This is the model class for table "Dialog".
 *
 * The followings are the available columns in table 'Dialog':
 * @property double $id
 * @property double $idRodzica
 * @property string $wypowiedzGracza
 * @property string $wypowiedzUrzednika
 * @property string $akcja
 * @property string $hash
 * @property string $skoczDoOdpowiedziZId
 * @property string $condition
 */
class Dialog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Dialog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Dialog';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idRodzica, skoczDoWypowiedziZId', 'numerical'),
			array('wypowiedzGracza, wypowiedzUrzednika', 'length', 'max'=>1000),
			array('akcja, hash, condition', 'length', 'max'=>32),

			array('id, idRodzica, wypowiedzGracza, wypowiedzUrzednika, akcja, hash, condition', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Dialog', 'ID'),
			'idRodzica'=>Yii::t('Dialog', 'Rodzic'),
			'wypowiedzGracza'=>Yii::t('Dialog', 'Wypowiedź gracza'),
			'wypowiedzUrzednika'=>Yii::t('Dialog', 'Wypowiedź rozmówcy'),
			'akcja'=>Yii::t('Dialog', 'Akcja po wybraniu pozycji. Tag wnętrz (bez prefixu) lub uchyt zdarzenia js (prefix js:).'),
			'skoczDoWypowiedziZId'=>Yii::t('Dialog', 'Wypowiedzi, do której należy przeskoczyć po kliknięciu w tę odpowiedź'),
			'hash'=>Yii::t('Dialog', 'Hash wnętrza'),
			'condition'=>Yii::t('Dialog', 'Warunek (uchwyt js)'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('"t"."id"', $this->id);
		$criteria->compare('"t"."idRodzica"', $this->idRodzica);
		$criteria->compare('LOWER("t"."wypowiedzGracza")', strtolower($this->wypowiedzGracza), true);
		$criteria->compare('LOWER("t"."wypowiedzUrzednika")', strtolower($this->wypowiedzUrzednika), true);
		$criteria->compare('LOWER("t"."akcja")', strtolower($this->akcja), true);
		$criteria->compare('LOWER("t"."hash")', strtolower($this->hash), true);

		$criteria->addCondition('"t"."idRodzica" IS NULL');

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public function getRoot()
	{
		$sql = 'SELECT "rootId"
			FROM (
				SELECT "id" as "rootId"
				FROM "Dialog"
				START WITH "id" = '.$this->id.'
				CONNECT BY PRIOR "idRodzica" = "id"
				ORDER BY LEVEL DESC
			)
			WHERE rownum <=1';

		return Dialog::model()->find('"id"=('.$sql.')');
	}

	public function getDialogue($hash)
	{
                // in case of bank dialogue - replacing fees
                if(in_array($hash, array('intBank1r1','intBank1r2','intBank2r1','intBank2r2','intBank3r1','intBank3r2','intBank4r1','intBank4r2')))
                {
                    $sql = 'SELECT "Dialog"."id", "idRodzica", "wypowiedzGracza", REPLACE(REPLACE(REPLACE(REPLACE("wypowiedzUrzednika", \'[oplataZalozenie]\', "Bank"."oplataZalozenie"), \'[oplataMiesieczna]\', "Bank"."oplataMiesieczna"),\'[oplataPrzelew]\',"Bank"."oplataPrzelew"),\'[oprocentowanie]\',"Bank"."oprocentowanie") AS "wypowiedzUrzednika", "akcja","hash", "skoczDoWypowiedziZId", "condition", LEVEL
                            FROM "Dialog"
                            LEFT JOIN "Bank" ON "Bank"."id" = '.$this->hashToBankId($hash).'
                            START WITH "hash" = \''.$hash.'\'
                            CONNECT BY PRIOR "Dialog"."id" = "idRodzica"
                            ORDER SIBLINGS BY "Dialog"."id","wypowiedzGracza"';
                }
                else
                {
                    $sql = 'SELECT "id", "idRodzica", "wypowiedzGracza", "wypowiedzUrzednika", "akcja","hash", "skoczDoWypowiedziZId", "condition", LEVEL
                            FROM "Dialog"
                            START WITH "hash" = \''.$hash.'\'
                            CONNECT BY PRIOR "id" = "idRodzica"
                            ORDER SIBLINGS BY "id","wypowiedzGracza"';
                }

		return Yii::app()->db->createCommand($sql)->queryAll();
	}
        
        public function hashToBankId($hash)
        {
		switch ($hash)
		{
			case 'intBank1r1':
			case 'intBank1r2':
				return 1;
			break;
			case 'intBank2r1':
			case 'intBank2r2':
				return 2;
			break;
			case 'intBank3r1':
			case 'intBank3r2':
				return 3;
			break;
			case 'intBank4r1':
			case 'intBank4r2':
				return 4;
			break;
		}
	}

	public function getDialogueThree($editOptions=null)
	{
		$sql = 'SELECT "id", "idRodzica", "wypowiedzGracza", "wypowiedzUrzednika", "akcja","hash", "skoczDoWypowiedziZId", "condition", LEVEL
			FROM "Dialog"
			START WITH "id" = \''.$this->id.'\'
			CONNECT BY PRIOR "id" = "idRodzica"
			ORDER SIBLINGS BY "id","wypowiedzGracza"';

		$conversation = Yii::app()->db->createCommand($sql)->queryAll();
		$conversationRows = array();

		$rootId = 0;

		foreach($conversation as $statement)
		{
			if(empty($statement['idRodzica']))
				$rootId = $statement['id'];

			$conversationRows[$statement['id']] = $statement;
		}

		$conversationThree = $this->buildThree($conversationRows,$rootId,$editOptions);

		return array($conversationThree);
	}

	public function getDialogueEditThree()
	{
		return $this->getDialogueThree(true);
	}

	public function buildThree($conversationData,$currentStatementId,$editOptions=null)
	{
		$returnArray = array();
		$childrenArray = array();

		foreach($conversationData as $statement)
		{
			if($statement['idRodzica'] == $currentStatementId)
			{
				$three = $this->buildThree($conversationData,$statement['id'],$editOptions);
				if(!empty($three))
					$childrenArray[] = $three;
			}
		}

		$returnArray['text'] = '<b>#'.$conversationData[$currentStatementId]['id'].'</b>
					<b>Wypowiedź gracza:</b> <i>"'.$conversationData[$currentStatementId]['wypowiedzGracza'].'"</i><br />
					<b>Wypowiedź rozmówcy:</b> <i>'.$conversationData[$currentStatementId]['wypowiedzUrzednika'].'</i><br />
					';

		if(!empty($conversationData[$currentStatementId]['akcja']))
			$returnArray['text'] .= '<b>Akcja</b> '.$conversationData[$currentStatementId]['akcja'].'<br />';

		if(!empty($conversationData[$currentStatementId]['skoczDoWypowiedziZId']))
			$returnArray['text'] .= '<b>Skocz do wypowiedzi nr </b> '.$conversationData[$currentStatementId]['skoczDoWypowiedziZId'].'<br />';

		if(!empty($conversationData[$currentStatementId]['condition']))
			$returnArray['text'] .= '<b>Warunek </b> '.$conversationData[$currentStatementId]['condition'].'<br />';

		if($editOptions)
			$returnArray['text'] .= '<a href="'.Yii::app()->createUrl('/administration/dialog/createChildStatement',array('parentId'=>$conversationData[$currentStatementId]['id'])).'">Dodaj potomka</a>
				| <a href="'.Yii::app()->createUrl('/administration/dialog/updateStatement',array('id'=>$conversationData[$currentStatementId]['id'])).'">Edytuj tę wypowiedź</a>
				| '.CHtml::link('Usuń tę wypowiedź (i wszystkich jej potomków)', array('/administration/dialog/delete','id'=>$conversationData[$currentStatementId]['id']), array('confirm' => 'Czy na pewno chcesz usunąć tę wypowiedź?')).'<br />';

		if(!empty($childrenArray))
			$returnArray['children'] = $childrenArray;

		$returnArray['expanded'] = true;

		return $returnArray;
	}

	//deletes current model and all of its children
	public function deleteChildren()
	{
		$sql = 'DELETE FROM "Dialog" WHERE "id" IN (SELECT "id"
			FROM "Dialog"
			START WITH "id" = '.$this->id.'
			CONNECT BY PRIOR "id" = "idRodzica")';

		Yii::app()->db->createCommand($sql)->execute();
	}

	public function getOtherDialogues()
	{
		if (empty($this->id))
			return Yii::app()->db->createCommand('
				select "t"."id", nvl("t"."hash", \'\')||\' - \'||"t"."id"||\' - \'||
					SUBSTR("t"."wypowiedzGracza"||\' \'||"t"."wypowiedzUrzednika",1,50)||
					\'...\' "text" from "Dialog" "t"
				start with "t"."idRodzica" is null
				connect by prior "t"."id" = "t"."idRodzica"
			')->queryAll(true);
		else
			return Yii::app()->db->createCommand('
				select "t"."id", nvl("t"."hash", \'\')||\' - \'||"t"."id"||\' - \'||
					SUBSTR("t"."wypowiedzGracza"||\' \'||"t"."wypowiedzUrzednika",1,50)||
					\'...\' "text" from "Dialog" "t"
				where "t"."id" <> :dialogId
				start with "t"."idRodzica" is null
				connect by prior "t"."id" = "t"."idRodzica"
			')->queryAll(true, array(':dialogId' => $this->id));
	}
}
